#include <iostream>
#include <stdlib.h>

using namespace std;

/*
 * Sprawdza czy liczba jest parzysta
 */
bool czyParzysta(int liczba) 
{
     return (liczba % 2) == 0;
}

/*
 * Struktura reprezentujaca element listy
 */
struct ElementListy 
{
       int wartosc;
       ElementListy *nastepny;             
};

ElementListy *glowa;

/*
 * Funkcja dodajaca element do listy
 */
void dodajDoListy(int liczba) 
{
     ElementListy *nowyElement = new ElementListy(); // tworzony jest nowy element
     nowyElement->wartosc = liczba; // wypelniana jest wartosc elementu
     nowyElement->nastepny = NULL;

     if(glowa == NULL) // jezeli nie ma zadnego elementu na liscie
     {
         glowa = nowyElement; // nowy element staje sie pierwszym elementem na liscie
     } 
     else 
     {
         // jezeli sa juz elementy na liscie stworz tymczasowy wskaznik wskazujacy na poczatek listy
         ElementListy *temp = glowa;

         // przesuwamy tymczasowy wskanik dopoki istnieje element nastepny
         while (temp->nastepny)
         {
            temp = temp->nastepny;
         }

         temp->nastepny = nowyElement;  // ostatni element wskazuje na nowo dodany
         nowyElement->nastepny = NULL;     // nowo dodany nie wskazuje na zaden inny element  
     }           
}

int main()
{
    int liczbaSpr = 0;
    char* bufor = new char [100];
    
    do 
    {
        cout << endl << "Podaj liczbe (ENTER bez liczby, aby zakonczyc) ";
        cin.getline(bufor, 100);
        
        if(*bufor != '\0') {                 // jezeli bufor nie pusty
            int liczba = atoi (bufor);       // konwertuj z tablicy znakow na liczbe
            dodajDoListy(liczba); // dodaj do listy
        } 
        
    } while(*bufor != '\0');
    
    cout<<"\nLiczby parzyste: ";
    
    // toworzymy tymczasowy wskaznik do wskazywania aktualnego elementu na liscie
    ElementListy *temp = glowa; 

    while (temp) // dopoki element rozny od NULL
    {
          // wypisz liczbe jezeli parzysta
          if(czyParzysta(temp->wartosc)) 
          {
              cout<<temp->wartosc<<", ";                                      
          }  
          // niech tymczasowy wskaznik wskazuje na nastepny element na liscie
          temp = temp->nastepny;
    }

    delete glowa;
    glowa = NULL;
 
    cout <<endl << "\n\nNacisnij ENTER, aby kontynuowac...";
    
    cin.get();
    
    return 0;
}
